/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.video;

import dioscuri.module.video.AttributeController;
import dioscuri.module.video.CRTControllerRegister;
import dioscuri.module.video.ColourRegister;
import dioscuri.module.video.GraphicsController;
import dioscuri.module.video.MiscellaneousOutputRegister;
import dioscuri.module.video.Pixel;
import dioscuri.module.video.SequencerRegister;
import java.util.Arrays;

public class VideoCard {
    private static final int XRES_MAX = 800;
    private static final int YRES_MAX = 600;
    protected static final int X_TILESIZE = 16;
    protected static final int Y_TILESIZE = 24;
    private static final int X_NUM_TILES = 50;
    private static final int Y_NUM_TILES = 25;
    byte[] tile = new byte[1536];
    boolean[][] vgaTileUpdated = new boolean[50][25];
    MiscellaneousOutputRegister miscOutputRegister = new MiscellaneousOutputRegister();
    SequencerRegister sequencer = new SequencerRegister();
    GraphicsController graphicsController = new GraphicsController();
    CRTControllerRegister crtControllerRegister = new CRTControllerRegister();
    AttributeController attributeController = new AttributeController();
    ColourRegister colourRegister = new ColourRegister();
    Pixel[] pixels = new Pixel[256];
    boolean vgaEnabled;
    byte vertRetrace;
    byte displayDisabled;
    byte horizRetrace;
    public byte[] vgaMemory = new byte[262144];
    boolean vgaMemReqUpdate;
    public byte[] textSnapshot = new byte[131072];
    int lineOffset;
    int lineCompare;
    int verticalDisplayEnd;

    public VideoCard() {
        Arrays.fill(this.pixels, new Pixel());
    }

    protected final void setTileUpdate(int n, int n2, boolean bl) {
        if (n < 50 && n2 < 25) {
            this.vgaTileUpdated[n][n2] = bl;
        }
    }

    protected final boolean getTileUpdate(int n, int n2) {
        return n < 50 && n2 < 25 ? this.vgaTileUpdated[n][n2] : false;
    }

    public void reset() {
        this.miscOutputRegister.reset();
        this.sequencer.reset();
        this.graphicsController.reset();
        this.crtControllerRegister.reset();
        this.attributeController.reset();
        this.colourRegister.reset();
        this.vgaEnabled = true;
        this.vgaMemReqUpdate = false;
        this.lineOffset = 80;
        this.lineCompare = 1023;
        this.verticalDisplayEnd = 399;
        for (int i = 0; i < 256; ++i) {
            this.pixels[i].red = 0;
            this.pixels[i].green = 0;
            this.pixels[i].blue = 0;
        }
        Arrays.fill(this.vgaMemory, (byte)0);
    }
}

